#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_PatientUnitSelectionMessage : BaseTest 
	{
		
		private BOL.PatientUnitSelectionMessage _tstPUSM;
		private string _eyeReadableUnitId = "1234567890";
		private string _messageText = "UnitTesting";

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
			
			_tstPUSM = new BOL.PatientUnitSelectionMessage(_eyeReadableUnitId, Common.UC03UnitSelectErrorMessages.UnitNotCompatible, true, _messageText);
		}

		[Test]
		public void Ctor_String_Enum_Bool_String_Pass()
		{
			Assert.IsNotNull(this._tstPUSM);
			Assert.AreEqual(this._tstPUSM.EyeReabableUnitID, this._eyeReadableUnitId);
			Assert.AreEqual(this._tstPUSM.MessageText, this._messageText);
			Assert.AreEqual(this._tstPUSM.OverRideable, true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_String_Enum_Bool_String_Fail()
		{
		}

		[Test]
		public void EyeReabableUnitID_Pass()
		{
			string tstValue = this._tstPUSM.EyeReabableUnitID;

			Assert.AreEqual(this._tstPUSM.EyeReabableUnitID, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void EyeReabableUnitID_Fail()
		{
		}

		[Test]
		public void Message_Pass()
		{
			Common.UC03UnitSelectErrorMessages tstValue = Common.UC03UnitSelectErrorMessages.BR301Specimen;

			this._tstPUSM.Message = tstValue;

			Assert.AreEqual(this._tstPUSM.Message, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Message_Fail()
		{
		}

		[Test]
		public void OverRideable_Pass()
		{
			bool tstValue = (!this._tstPUSM.OverRideable);

			this._tstPUSM.OverRideable = tstValue;

			Assert.AreEqual(this._tstPUSM.OverRideable, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void OverRideable_Fail()
		{
		}

		
		[Test]
		public void MessageText_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstPUSM.MessageText = tstValue;

			Assert.AreEqual(this._tstPUSM.MessageText, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MessageText_Fail()
		{
		}

		
		[Test]
		public void Beep_Pass()
		{
			bool tstValue = this._tstPUSM.Beep;

			Assert.AreEqual(this._tstPUSM.Beep, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Beep_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Pass()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

	}
}

#endif
